<?php
header('Content-Type: application/json; charset=utf-8');

$role = $_GET['role'] ?? '';
if (!in_array($role, ['rektor', 'yayasan'], true)) {
  http_response_code(400);
  echo json_encode(['ok' => false, 'msg' => 'invalid role']); exit;
}

$since = intval($_GET['since'] ?? 0);

$dir = __DIR__ . '/../data';
$streamFile = $dir . "/stream_{$role}.ndjson";
$stateFile  = $dir . "/state_{$role}.json";

if (!file_exists($stateFile)) {
  echo json_encode(['ok'=>true,'events'=>[],'last'=>0,'done'=>false]); exit;
}

$state = json_decode(file_get_contents($stateFile), true);
if (!is_array($state)) $state = ['seq'=>0,'done'=>false,'updated'=>time()];

$done = boolval($state['done'] ?? false);
$last = intval($state['seq'] ?? 0);

$events = [];
if (file_exists($streamFile)) {
  $fh = fopen($streamFile, 'r');
  if ($fh) {
    while (($line = fgets($fh)) !== false) {
      $line = trim($line);
      if ($line === '') continue;
      $e = json_decode($line, true);
      if (!is_array($e)) continue;
      if (intval($e['seq'] ?? 0) > $since) $events[] = $e;
    }
    fclose($fh);
  }
}

echo json_encode([
  'ok' => true,
  'events' => $events,
  'last' => $last,
  'done' => $done
]);