<?php
header('Content-Type: application/json; charset=utf-8');

$role = $_GET['role'] ?? '';
if (!in_array($role, ['rektor', 'yayasan'], true)) {
  http_response_code(400);
  echo json_encode(['ok' => false, 'msg' => 'invalid role']); exit;
}

$dir = __DIR__ . '/../data';
if (!is_dir($dir)) mkdir($dir, 0775, true);

$stateFile = $dir . "/state_{$role}.json";
$state = file_exists($stateFile) ? json_decode(file_get_contents($stateFile), true) : ['seq'=>0,'done'=>false,'updated'=>time()];
if (!is_array($state)) $state = ['seq'=>0,'done'=>false,'updated'=>time()];

$state['done'] = true;
$state['updated'] = time();
file_put_contents($stateFile, json_encode($state, JSON_PRETTY_PRINT));

echo json_encode(['ok'=>true,'done'=>true]);